//SortParagraphs.jsx
//An InDesign CS3 JavaScript
/*  
@@@BUILDINFO@@@ "SortParagraphs.jsx" 1.0.0 14-September-2006
*/
//Sorts the paragraphs in the selection in alphabetical order.
//
//For more on InDesign scripting, go to http://www.adobe.com/products/indesign/scripting.html
//or visit the InDesign Scripting User to User forum at http://www.adobeforums.com
//
main();
function main(){
	if(app.documents.length != 0){
		if(app.selection.length > 0){
			switch(app.selection[0].constructor.name){
				case "Text":
				case "TextColumn":
				case "TextFrame":
					mySortParagraphs();
					break;
			}
		}
		else{
			alert("Please select at least two paragraphs of text (or a text frame) try again.");
		}
	}
	else{
		alert("No documents are open. Please open a document and try again.");
	}
}
function mySortParagraphs(){
	var myParagraphs, myCleanUp, myItemMoved, myCounter;
	if(app.selection[0].constructor.name == "TextFrame"){
		myParagraphs = app.selection[0].paragraphs;
	}
	else{
		if((app.selection[0].contents == "")||(app.selection[0].paragraphs.length <= 1)){
			myParagraphs = app.selection[0].parentTextFrames[0].paragraphs;
		}
		else{
			myParagraphs = app.selection[0].paragraphs;
		}
	}
	//If the last paragraph in the selection is the last paragraph of the story,
	//and if the last paragraph does not end in a carriage return character,
	//then add a carriage return character at the end of the last paragraph.
	if(myParagraphs.item(0).parentStory.insertionPoints.item(-1).index == myParagraphs.item(-1).insertionPoints.item(-1).index){
		myParagraphs.item(-1).insertionPoints.item(-1).contents = "\r";
		myCleanUp = true;
	}
	else{
		myCleanUp = false;
	}
	//Simple bubble sort
	do{
		myItemMoved = false;
		myCounter = 0;
		do{
			if(myParagraphs.item(myCounter).contents > myParagraphs.item(myCounter+1).contents){
				myParagraphs.item(myCounter).move(LocationOptions.after, myParagraphs.item(myCounter+1));
				myItemMoved = true;
			}
			myCounter ++;
        	}while (myCounter < myParagraphs.length-1);	
		myCounter = myParagraphs.length-1;
		do{
			if(myParagraphs.item(myCounter).contents < myParagraphs.item(myCounter-1).contents){
				myParagraphs.item(myCounter).move(LocationOptions.before, myParagraphs.item(myCounter-1));
				myItemMoved = true;
			}
			myCounter --;
		}while(myCounter > 1);
	}while(myItemMoved != false);
	//If we added a return at the end of the story, we should now
	//remove the extra return at the end of the story.
	if(myCleanUp == true){
		myParagraphs.item(0).parentStory.characters.item(-1).remove();
	}
}